//================================================================================
//
// SOTheadremover mutator by [AMLP]TheDane - thedane_ut@hotmail.com
//
//================================================================================
class SOTSniperRifleV1 expands TournamentWeapon;


#exec TEXTURE IMPORT NAME=Reticle FILE=Textures\RReticle.pcx FLAGS=2 MIPS=OFF

#exec TEXTURE IMPORT NAME=SOTUseRifle FILE=Textures\SOTUseRifle.pcx MIPS=OFF
#exec TEXTURE IMPORT NAME=SOTIconRifle FILE=Textures\SOTIconRifle.pcx MIPS=OFF

#exec AUDIO IMPORT FILE="Sounds\SniperFire.wav" NAME="SniperFire" GROUP="Rifle"

#exec TEXTURE IMPORT NAME=SOTRifle2a FILE=Textures\SOTRifle2a.pcx GROUP=Rifle
#exec TEXTURE IMPORT NAME=SOTRifle2b FILE=Textures\SOTRifle2b.pcx GROUP=Rifle

//#exec TEXTURE IMPORT NAME=SOTRifle2 FILE=Textures\SOTRifle2.pcx GROUP=Skins LODSET=2
//#exec MESHMAP SETTEXTURE MESHMAP=RifleHand NUM=2 TEXTURE=SOTRifle2

//var bool bShowMag;
//var bool bShowRangeText;
//var bool bShowRange; //
//var bool bShowriflename;
var bool bShowDots;  //
//var string riflename;
var int NumFire;
var name FireAnims[5];
var vector OwnerLocation;
var float StillTime, StillStart;
var bool bZoom;
//var float lAccuracy;  //acc count

simulated event PostNetBeginPlay()
{
	local HUDMutator crosshair;
	local PlayerPawn HUDOwner;

	Super.PostNetBeginPlay();

	// If owner is the local player, check that the HUD Mutator exists. Also check for the presense of a bbPlayer (UTPure enabled)
	HUDOwner = PlayerPawn(Owner);
	if (HUDOwner != None && HUDOwner.IsA('bbPlayer') && HUDOwner.myHUD != None)
	{
		ForEach AllActors(Class'HUDMutator', crosshair)
			break;
		if (crosshair == None)
		{
			crosshair = Spawn(Class'HUDMutator', Owner);
			crosshair.RegisterHUDMutator();
			crosshair.HUDOwner = HUDOwner;
		}
	}
}

simulated function PostRender( canvas Canvas )        /// zoom canvas
{
	local PlayerPawn P;
	local float Scale;
	local float Xlength;
	local float range;
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z;
	local float radpitch;
	local actor Other;

	Super.PostRender(Canvas);
	P = PlayerPawn(Owner);
	if ( (P != None) && (P.DesiredFOV != P.DefaultFOV) )
	{
		bOwnsCrossHair = true;

		////////Cross hair lens
		Scale = Canvas.ClipX/640;
		Canvas.SetPos(0.5 * Canvas.ClipX - 128 * Scale, 0.5 * Canvas.ClipY - 128 * Scale );
		if ( Level.bHighDetailMode )
			Canvas.Style = ERenderStyle.STY_Translucent;
		else
			Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.DrawColor = 15*ChallengeHUD(PlayerPawn(Owner).myhud).CrosshairColor; //?
		Canvas.DrawIcon(Texture'Reticle', Scale);
		/// dots
		Canvas.Style = ERenderStyle.STY_Normal;
		if(bShowDots)
		{
			Canvas.SetPos(0.5 * Canvas.ClipX + 5 * Scale, 0.5 * Canvas.ClipY - 6 * Scale);
			Canvas.DrawColor.R = 255;
			Canvas.DrawColor.G = 0;
			Canvas.DrawColor.B = 0;

			Canvas.DrawText("---------");    //left
			Canvas.SetPos(0.5 * Canvas.ClipX - 27 * Scale, 0.5 * Canvas.ClipY - 6 * Scale);
			Canvas.DrawText("---------");   //right
			Canvas.SetPos(0.5 * Canvas.ClipX - 2 * Scale, 0.5 * Canvas.ClipY + 5 * Scale);
			Canvas.DrawText("^");   //bottom
		}
		Scale = P.DefaultFOV/P.DesiredFOV;

		
			// Calc range
        		XLength=255.0;
			GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
			if ((Pawn(Owner).ViewRotation.Pitch >= 0) && (Pawn(Owner).ViewRotation.Pitch <= 18000))
				radpitch = float(Pawn(Owner).ViewRotation.Pitch) / float(182) * (Pi/float(180));
			else
				radpitch = float(Pawn(Owner).ViewRotation.Pitch - 65535) / float(182) * (Pi/float(180));

			StartTrace = Owner.Location + Pawn(Owner).EyeHeight*Z*cos(radpitch);
	    		AdjustedAim = pawn(owner).AdjustAim(1000000, StartTrace, 2.75*AimError, False, False);
			EndTrace = StartTrace +(20000 * vector(AdjustedAim));
			Other = Pawn(Owner).TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);
			range = Vsize(StartTrace-HitLocation)/48-0.25;

			// Magnification Display
			Canvas.SetPos( 202*Canvas.ClipX/401-50, 4*Canvas.ClipY/7 + Canvas.ClipY/401 );
			Canvas.Font = Font'Botpack.WhiteFont';
			Canvas.DrawColor.R = 0;
			Canvas.DrawColor.G = 0;
			Canvas.DrawColor.B = 196;
			Scale = P.DefaultFOV/P.DesiredFOV;
			Canvas.DrawText("X"$int(Scale)$"."$int(10 * Scale - 10 * int(Scale)));

			// Range Display
			Canvas.SetPos( 202*Canvas.ClipX/401, 4*Canvas.ClipY/7 + Canvas.ClipY/401 );
			Canvas.Font = Font'Botpack.WhiteFont';
			Canvas.DrawColor.R = 196;
			Canvas.DrawColor.G = 0;
			Canvas.DrawColor.B = 0;
	       	 	Canvas.DrawText( "R: "$int(range)$"."$int(10 * range -10 * int(range))$"");

	}

	else
	{
		bOwnsCrossHair = false;


	}
}

function float RateSelf( out int bUseAltMode )
{
	local float dist;

	if ( AmmoType.AmmoAmount <=0 )
		return -2;

	bUseAltMode = 0;
	if ( (Bot(Owner) != None) && Bot(Owner).bSniping )
		return AIRating + 1.15;
	if (  Pawn(Owner).Enemy != None )
	{
		dist = VSize(Pawn(Owner).Enemy.Location - Owner.Location);
		if ( dist > 1200 )
		{
			if ( dist > 2000 )
				return (AIRating + 0.75);
			return (AIRating + FMin(0.0001 * dist, 0.45));
		}
	}
	return AIRating;
}

// set which hand is holding weapon
function setHand(float Hand)
{
	Super.SetHand(Hand);
	if ( Hand == 1 )
		Mesh = mesh(DynamicLoadObject("Botpack.Rifle2mL", class'Mesh'));
	else
	{
		Mesh = mesh'Rifle2m';
		MultiSkins[0] = Texture'SOTheadremover.SOTSniperRifleV1.SOTRifle2A';
		MultiSkins[1] = Texture'SOTheadremover.SOTSniperRifleV1.SOTRifle2B';
	}	
}

// function DropFrom(vector StartLocation)
// {
// 	Destroy();
// }

simulated function PlayFiring()
{
	local int r;

	PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
	if ( (Owner.Physics != PHYS_Falling && Owner.Physics != PHYS_Swimming && Pawn(Owner).bDuck != 0)
	   || Owner.Velocity == 0 * Owner.Velocity )
		PlayAnim(FireAnims[/*Rand(5)*/4],3 + 3 * FireAdjust, 0.05);
	else
		PlayAnim(FireAnims[Rand(5)],0.3 + 0.3 * FireAdjust, 0.05);

	if ( (PlayerPawn(Owner) != None)
		&& (PlayerPawn(Owner).DesiredFOV == PlayerPawn(Owner).DefaultFOV) )
		bMuzzleFlash++;
}

simulated function bool ClientAltFire( float Value )
{
	GotoState('Zooming');
	return true;
}

function AltFire( float Value )
{
	ClientAltFire(Value);
}

function Fire( float Value )
{
	if ( (AmmoType == None) && (AmmoName != None) )
	{
		// ammocheck
		GiveAmmo(Pawn(Owner));
	}
	if ( AmmoType.UseAmmo(1) )
	{
		GotoState('NormalFire');
		bPointing=True;
		bCanClientFire = true;
		ClientFire(Value);
		if ( bRapidFire || (FiringSpeed > 0) )
			Pawn(Owner).PlayRecoil(FiringSpeed);
		if ( bInstantHit )
		{
			if ( (Owner.Physics != PHYS_Falling && Owner.Physics != PHYS_Swimming && Pawn(Owner).bDuck != 0)
			   || Owner.Velocity == 0 * Owner.Velocity )
				TraceFire(0.0);
			else
				TraceFire(16);
		}
		else
			ProjectileFire(ProjectileClass, ProjectileSpeed, bWarnTarget);
	}
}

///////////////////////////////////////////////////////
state NormalFire
{
	function EndState()
	{
		Super.EndState();
		OldFlashCount = FlashCount;
	}

Begin:
		FlashCount++;
}

function Timer()
{
	local actor targ;
	local float bestAim, bestDist;
	local vector FireDir;
	local Pawn P;

	bestAim = 0.95;
	P = Pawn(Owner);
	if ( P == None )
	{
		GotoState('');
		return;
	}
	if ( VSize(P.Location - OwnerLocation) < 6 )
		StillTime += FMin(2.0, Level.TimeSeconds - StillStart);

	else
		StillTime = 0;
	StillStart = Level.TimeSeconds;
	OwnerLocation = P.Location;
	FireDir = vector(P.ViewRotation);
	targ = P.PickTarget(bestAim, bestDist, FireDir, Owner.Location);
	if ( Pawn(targ) != None )
	{
		SetTimer(1 + 4 * FRand(), false);
		bPointing = true;
		Pawn(targ).WarnTarget(P, 200, FireDir);
	}
	else
	{
		SetTimer(0.4 + 1.6 * FRand(), false);
		if ( (P.bFire == 0) && (P.bAltFire == 0) )
			bPointing = false;
	}
}

function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	local UT_Shellcase s;

	s = Spawn(class'UT_ShellCase',, '', Owner.Location + CalcDrawOffset() + 30 * X + (2.8 * FireOffset.Y+5.0) * Y - Z * 1);

	if ( s != None )
	{
		s.DrawScale = 0.85;
		s.Eject(((FRand()*0.3+0.4)*X + (FRand()*0.2+0.2)*Y + (FRand()*0.3+1.0) * Z)*160);
	}
	if (Other == Level)
		Spawn(class'UT_HeavyWallHitEffect',,, HitLocation+HitNormal, Rotator(HitNormal)); // UT_HeavyWallHitEffect

	else if ( (Other != self) && (Other != Owner) && (Other != None) )
	{
		if ( Other.bIsPawn )
			Other.PlaySound(Sound 'Mdeath1',, 4.0,,100); //Mdeath1
	             //  	Other.PlaySound(Sound 'UnrealShare.splat2tn',, 4.0,,100);
			PlayOwnedSound(Sound 'UnrealShare.splat2tn',, 4.0,,10);
		if ( Other.bIsPawn && (HitLocation.Z - Other.Location.Z > 0.62 * Other.CollisionHeight)
			&& (instigator.IsA('PlayerPawn') || (instigator.IsA('Bot') && !Bot(Instigator).bNovice))
			&& ((Owner.Physics != PHYS_Falling && Owner.Physics != PHYS_Swimming && Pawn(Owner).bDuck != 0)
			   || Owner.Velocity == 0 * Owner.Velocity) )
			Other.TakeDamage(100, Pawn(Owner), HitLocation, 35000 * X, AltDamageType);
		else
			Other.TakeDamage(50,  Pawn(Owner), HitLocation, 30000.0*X, MyDamageType);
		if ( !Other.bIsPawn && !Other.IsA('Carcass') )
			spawn(class'UT_SpriteSmokePuff',,,HitLocation+HitNormal*9);

	}
}

function Finish()
{
	if ( (Pawn(Owner).bFire!=0) && (FRand() < 0.6) )
		Timer();
	Super.Finish();
}

function TraceFire( float Accuracy )
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z;
	local actor Other;
	local Pawn PawnOwner;

	PawnOwner = Pawn(Owner);

	Owner.MakeNoise(PawnOwner.SoundDampening);
	GetAxes(PawnOwner.ViewRotation,X,Y,Z);
	StartTrace = Owner.Location + PawnOwner.Eyeheight * Z;
	AdjustedAim = PawnOwner.AdjustAim(1000000, StartTrace, 2*AimError, False, False);
	// added to stop monkeys firing of their first shot stright
	if ( (Owner.Physics != PHYS_Falling && Owner.Physics != PHYS_Swimming && Pawn(Owner).bDuck != 0)
			   || Owner.Velocity == 0 * Owner.Velocity )
		{
		EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000 + Accuracy * (FRand() - 0.5 ) * Z * 1000;
		}
	else
	{
		Accuracy = 100;
		EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000 + Accuracy * (FRand() - 0.5 ) * Z * 1000;
	}
	///////
	X = vector(AdjustedAim);
	EndTrace += (100000 * X);
	Other = PawnOwner.TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);
	if (FRand()>0.80)   /// random works for all shots
	{                    // TRACER
		if(VSize(HitLocation-StartTrace)>100) Spawn(class'SOTTracer',,,StartTrace+50*X, Rotator(EndTrace-StartTrace));
	}
	ProcessTraceHit(Other, HitLocation, HitNormal, X,Y,Z);
}


state Idle
{
	function Fire( float Value )
	{
		if ( AmmoType == None )
		{
			// ammocheck
			GiveAmmo(Pawn(Owner));
		}
		if (AmmoType.UseAmmo(1))
		{
			GotoState('NormalFire');
			bCanClientFire = true;
			bPointing=True;
			if ( Owner.IsA('Bot') )
			{
				// simulate bot using zoom
				// try to make it stand still when firing
				Owner.Velocity = 0 * Owner.Velocity;
				if ( Bot(Owner).bSniping && (FRand() < 0.65) )
					AimError = AimError/FClamp(StillTime, 1.0, 8.0);
				else if ( VSize(Owner.Location - OwnerLocation) < 6 )
					AimError = AimError/FClamp(0.5 * StillTime, 1.0, 3.0);
				else
					StillTime = 0;
			}
			Pawn(Owner).PlayRecoil(FiringSpeed);
			if ( (Owner.Physics != PHYS_Falling && Owner.Physics != PHYS_Swimming && Pawn(Owner).bDuck != 0)
			   || Owner.Velocity == 0 * Owner.Velocity )
				TraceFire(0.0);
			else
				TraceFire(100);
			AimError = Default.AimError;
			ClientFire(Value);
		}
	}


	function BeginState()
	{
		bPointing = false;
		SetTimer(0.4 + 1.6 * FRand(), false);
		Super.BeginState();
	}

	function EndState()
	{
		SetTimer(0.0, false);
		Super.EndState();
	}

Begin:
	bPointing=False;
	if ( AmmoType.AmmoAmount<=0 )
	{
		if ( PlayerPawn(Owner).DesiredFOV != PlayerPawn(Owner).DefaultFOV )
		{
			PlayerPawn(Owner).DesiredFOV = PlayerPawn(Owner).DefaultFOV;
			GoToState('Idle');
		}

		Pawn(Owner).SwitchToBestWeapon();  //Goto Weapon that has Ammo
	}
	if ( Pawn(Owner).bFire!=0 ) Fire(0.0);
	Disable('AnimEnd');
	PlayIdleAnim();
}

///////////////////////////////////////////////////////
state Zooming
{
	simulated function Tick(float DeltaTime)
	{
		if ( Pawn(Owner).bAltFire == 0 )
		{
			bZoom = false;
			SetTimer(0.0,False);
			GoToState('Idle');
		}
		else if ( bZoom )
		{
			if ( PlayerPawn(Owner).DesiredFOV > 1 )
			{
				PlayerPawn(Owner).DesiredFOV -= PlayerPawn(Owner).DesiredFOV*DeltaTime*3;
			}

			if ( PlayerPawn(Owner).DesiredFOV <=1 )
			{
				PlayerPawn(Owner).DesiredFOV = 1;
				bZoom = false;
				SetTimer(0.0,False);
				GoToState('Idle');
			}
		}
	}

	simulated function BeginState()
	{
		if ( Owner.IsA('PlayerPawn') )
		{
			if ( PlayerPawn(Owner).DesiredFOV == PlayerPawn(Owner).DefaultFOV )
			{
				bZoom = true;
				SetTimer(0.2,True);
			}
			else if ( bZoom == false )
			{
				PlayerPawn(Owner).DesiredFOV = PlayerPawn(Owner).DefaultFOV;
				Pawn(Owner).bAltFire = 0;
			}
		}
		else
		{
			Pawn(Owner).bFire = 1;
			Pawn(Owner).bAltFire = 0;
			Global.Fire(0);
		}
	}
}

///////////////////////////////////////////////////////////
simulated function PlayIdleAnim()
{
	if ( Mesh != PickupViewMesh )
		PlayAnim('Still',1.0, 0.05);
}


defaultproperties
{
     FireAnims(0)=Fire
     FireAnims(1)=Fire2
     FireAnims(2)=Fire3
     FireAnims(3)=Fire4
     FireAnims(4)=Fire5
     WeaponDescription="Classification: Long Range Ballistic Sniper Rifle"
     AmmoName=Class'SOTheadremover.SOTSniperAmmo'
     PickupAmmoCount=150
     bInstantHit=True
     bAltInstantHit=True
     bCanThrow=True
     FiringSpeed=1.100000
     FireOffset=(Y=-5.000000,Z=-2.000000)
     MyDamageType=shot
     AltDamageType=Decapitated
     shakemag=100.000000
     shaketime=0.150000
     shakevert=8.000000
     AIRating=0.540000
     RefireRate=4.000000
     AltRefireRate=0.150000
     FireSound=Sound'SOTheadremover.Rifle.SniperFire'
//     FireSound=Sound'BotPack.TDisrupt'
     AltFireSound=Sound'UnrealShare.AutoMag.shot'
     SelectSound=Sound'UnrealI.Rifle.RiflePickup'
     DeathMessage="%o was fragged by %k !!!!"
     NameColor=(R=0,G=0)
     MuzzleScale=1.000000
     FlashY=0.110000
     FlashO=0.010000
     FlashC=0.030000
     FlashLength=0.010000
     FlashS=256
     MFTexture=Texture'Botpack.Rifle.MuzzleFlash2'
     AutoSwitchPriority=5
     InventoryGroup=10
     PickupMessage="Yehaw! You picked up the SOT headremover!"
     ItemName="SOT headremover"
     PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
     PlayerViewMesh=LodMesh'Botpack.Rifle2m'
     PlayerViewScale=2.000000
     BobDamping=0.980000
     PickupViewMesh=LodMesh'Botpack.RiflePick'
     ThirdPersonMesh=LodMesh'Botpack.RifleHand'
     StatusIcon=Texture'SOTUseRifle'
     MuzzleFlashStyle=STY_Translucent
     MuzzleFlashMesh=LodMesh'Botpack.muzzsr3'
     MuzzleFlashTexture=Texture'Botpack.Skins.Muzzy3'
     PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
     Icon=Texture'SOTIconRifle'
     Rotation=(Roll=-512)
     Mesh=LodMesh'Botpack.RiflePick'
     bNoSmooth=False
     CollisionRadius=32.000000
     CollisionHeight=8.000000
}

